<?= $this->extend('layouts/admin') ?>

<?= $this->section('content') ?>
<div class="d-flex justify-content-between align-items-center mb-4">
    <h2 class="mb-0">
        <i class="bi bi-code-square me-2"></i>Kelola Project
    </h2>
    <a href="<?= base_url('admin/projects/create') ?>" class="btn btn-primary">
        <i class="bi bi-plus-circle me-1"></i>Tambah Project
    </a>
</div>

<?php if (session()->getFlashdata('success')): ?>
    <div class="alert alert-success alert-dismissible fade show" role="alert">
        <i class="bi bi-check-circle me-2"></i><?= session()->getFlashdata('success') ?>
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
<?php endif; ?>

<?php if (session()->getFlashdata('error')): ?>
    <div class="alert alert-danger alert-dismissible fade show" role="alert">
        <i class="bi bi-exclamation-triangle me-2"></i><?= session()->getFlashdata('error') ?>
        <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
    </div>
<?php endif; ?>

<!-- Search and Filter Section -->
<div class="admin-card">
    <form method="GET" action="<?= base_url('admin/projects') ?>" class="row g-3">
        <div class="col-md-3">
            <label for="search" class="form-label">Cari Project</label>
            <input type="text" class="form-control" id="search" name="search" 
                   value="<?= esc($search) ?>" placeholder="Cari nama project...">
        </div>
        <div class="col-md-2">
            <label for="jenis_project" class="form-label">Jenis Project</label>
            <select class="form-select" id="jenis_project" name="jenis_project">
                <option value="">Semua</option>
                <option value="Web" <?= $filter['jenis_project'] === 'Web' ? 'selected' : '' ?>>Web</option>
                <option value="Mobile" <?= $filter['jenis_project'] === 'Mobile' ? 'selected' : '' ?>>Mobile</option>
                <option value="Game" <?= $filter['jenis_project'] === 'Game' ? 'selected' : '' ?>>Game</option>
                <option value="Desktop" <?= $filter['jenis_project'] === 'Desktop' ? 'selected' : '' ?>>Desktop</option>
                <option value="Lainnya" <?= $filter['jenis_project'] === 'Lainnya' ? 'selected' : '' ?>>Lainnya</option>
            </select>
        </div>
        <div class="col-md-2">
            <label for="tahun" class="form-label">Tahun</label>
            <input type="number" class="form-control" id="tahun" name="tahun" 
                   value="<?= esc($filter['tahun']) ?>" placeholder="Tahun...">
        </div>
        <div class="col-md-2">
            <label for="sort" class="form-label">Sort By</label>
            <select class="form-select" id="sort" name="sort">
                <option value="urutan" <?= $sort === 'urutan' ? 'selected' : '' ?>>Urutan</option>
                <option value="nama_project" <?= $sort === 'nama_project' ? 'selected' : '' ?>>Nama Project</option>
                <option value="jenis_project" <?= $sort === 'jenis_project' ? 'selected' : '' ?>>Jenis Project</option>
                <option value="tahun" <?= $sort === 'tahun' ? 'selected' : '' ?>>Tahun</option>
            </select>
        </div>
        <div class="col-md-1">
            <label for="order" class="form-label">Order</label>
            <select class="form-select" id="order" name="order">
                <option value="ASC" <?= $order === 'ASC' ? 'selected' : '' ?>>ASC</option>
                <option value="DESC" <?= $order === 'DESC' ? 'selected' : '' ?>>DESC</option>
            </select>
        </div>
        <div class="col-md-2 d-flex align-items-end">
            <button type="submit" class="btn btn-primary w-100">
                <i class="bi bi-funnel"></i>
            </button>
        </div>
    </form>
</div>

<!-- Projects Table -->
<div class="admin-card">
    <?php if (empty($projects)): ?>
        <div class="alert alert-info text-center">
            <i class="bi bi-info-circle me-2"></i>Tidak ada project yang ditemukan.
        </div>
    <?php else: ?>
        <div class="table-responsive">
            <table class="table table-hover">
                <thead>
                    <tr>
                        <th>No</th>
                        <th>Urutan</th>
                        <th>Foto</th>
                        <th>Nama Project</th>
                        <th>Jenis</th>
                        <th>Tahun</th>
                        <th>Link</th>
                        <th>Aksi</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $no = ($pager->getCurrentPage() - 1) * 10 + 1; ?>
                    <?php foreach ($projects as $p): ?>
                        <tr>
                            <td><?= $no++ ?></td>
                            <td><?= esc($p['urutan']) ?></td>
                            <td>
                                <?php if ($p['foto']): ?>
                                    <img src="<?= image_url('projects', $p['foto'], 50, 50) ?>" 
                                         alt="Foto" style="width: 50px; height: 50px; object-fit: cover; border-radius: 5px;"
                                         onerror="this.src='<?= base_url('placeholder/50/50') ?>'; this.onerror=null;">
                                <?php else: ?>
                                    <span class="text-white">-</span>
                                <?php endif; ?>
                            </td>
                            <td><?= esc($p['nama_project']) ?></td>
                            <td><span class="badge bg-primary"><?= esc($p['jenis_project']) ?></span></td>
                            <td><?= esc($p['tahun'] ?? '-') ?></td>
                            <td>
                                <?php if ($p['link_project']): ?>
                                    <a href="<?= esc($p['link_project']) ?>" target="_blank" class="btn btn-sm btn-outline-primary">
                                        <i class="bi bi-link-45deg"></i>
                                    </a>
                                <?php else: ?>
                                    <span class="text-white">-</span>
                                <?php endif; ?>
                            </td>
                            <td>
                                <a href="<?= base_url('admin/projects/edit/' . $p['id']) ?>" 
                                   class="btn btn-sm btn-warning btn-action">
                                    <i class="bi bi-pencil"></i>
                                </a>
                                <a href="<?= base_url('admin/projects/delete/' . $p['id']) ?>" 
                                   class="btn btn-sm btn-danger btn-action"
                                   onclick="return confirm('Yakin ingin menghapus project ini?')">
                                    <i class="bi bi-trash"></i>
                                </a>
                            </td>
                        </tr>
                    <?php endforeach; ?>
                </tbody>
            </table>
        </div>

        <!-- Pagination -->
        <?php if ($pager->getLastPage() > 1): ?>
            <nav aria-label="Page navigation" class="mt-4">
                <ul class="pagination">
                    <?php if ($pager->getCurrentPage() > 1): ?>
                        <li class="page-item">
                            <a class="page-link" href="<?= base_url('admin/projects?page=' . ($pager->getCurrentPage() - 1) . '&search=' . urlencode($search) . '&jenis_project=' . urlencode($filter['jenis_project']) . '&tahun=' . urlencode($filter['tahun']) . '&sort=' . $sort . '&order=' . $order) ?>">
                                <i class="bi bi-chevron-left"></i>
                            </a>
                        </li>
                    <?php endif; ?>
                    
                    <?php for ($i = 1; $i <= $pager->getLastPage(); $i++): ?>
                        <li class="page-item <?= $i == $pager->getCurrentPage() ? 'active' : '' ?>">
                            <a class="page-link" href="<?= base_url('admin/projects?page=' . $i . '&search=' . urlencode($search) . '&jenis_project=' . urlencode($filter['jenis_project']) . '&tahun=' . urlencode($filter['tahun']) . '&sort=' . $sort . '&order=' . $order) ?>">
                                Part <?= $i ?>
                            </a>
                        </li>
                    <?php endfor; ?>
                    
                    <?php if ($pager->getCurrentPage() < $pager->getLastPage()): ?>
                        <li class="page-item">
                            <a class="page-link" href="<?= base_url('admin/projects?page=' . ($pager->getCurrentPage() + 1) . '&search=' . urlencode($search) . '&jenis_project=' . urlencode($filter['jenis_project']) . '&tahun=' . urlencode($filter['tahun']) . '&sort=' . $sort . '&order=' . $order) ?>">
                                <i class="bi bi-chevron-right"></i>
                            </a>
                        </li>
                    <?php endif; ?>
                </ul>
            </nav>
        <?php endif; ?>
    <?php endif; ?>
</div>
<?= $this->endSection() ?>


